/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.base.helper.MobHelper;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.MoobloomsClient;
import svenhjol.charm.entity.MoobloomEntity;
import svenhjol.charm.entity.goal.BeeMoveToMoobloomGoal;

@Module(mod="charm", client=MoobloomsClient.class, hasSubscriptions=true, description="Mooblooms are cow-like mobs that come in a variety of flower types. They spawn flowers where they walk and can be milked for suspicious stew.")
public class Mooblooms
extends CharmModule {
    public static ResourceLocation ID = new ResourceLocation("charm", "moobloom");
    public static EntityType<MoobloomEntity> MOOBLOOM;
    private List<ResourceLocation> biomes;

    @Override
    public void register() {
        MOOBLOOM = RegistryHandler.entity(ID, EntityType.Builder.func_220322_a(MoobloomEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f).func_233606_a_(10));
        EntitySpawnPlacementRegistry.func_209343_a(MOOBLOOM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MoobloomEntity::canSpawn);
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        MobHelper.setEntityAttributes(MOOBLOOM, CowEntity.func_234188_eI_().func_233813_a_());
    }

    @Override
    public void init() {
        this.biomes = new ArrayList<ResourceLocation>(Collections.singletonList(new ResourceLocation("minecraft:flower_forest")));
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.isCanceled()) {
            this.tryAddGoalsToBee(event.getEntity());
        }
    }

    @SubscribeEvent
    public void on(BiomeLoadingEvent event) {
        if (!event.isCanceled()) {
            this.tryAddEntityToSpawn(event);
        }
    }

    private void tryAddGoalsToBee(Entity entity) {
        BeeEntity bee;
        if (entity instanceof BeeEntity && MobHelper.getGoals((MobEntity)(bee = (BeeEntity)entity)).stream().noneMatch(g -> g.func_220772_j() instanceof BeeMoveToMoobloomGoal)) {
            MobHelper.getGoalSelector((MobEntity)bee).func_75776_a(4, (Goal)new BeeMoveToMoobloomGoal(bee));
        }
    }

    private void tryAddEntityToSpawn(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        if (!this.biomes.contains(event.getName())) {
            return;
        }
        List spawner = event.getSpawns().getSpawner(EntityClassification.CREATURE);
        spawner.add(new MobSpawnInfo.Spawners(MOOBLOOM, 30, 5, 6));
    }
}

